	function hBS = LP_2_BS_FIR(hLP)
	
	% 	Generate the impulse response of a symmetric bandstop (stopband) filter 
	% 	from a lowpass FIR filter by replacing z > z^2
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		LW 2007-12-08
	% 	Modified by: 		
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(hLP) -1;
	if mod(N,2) == 1
		disp(['Error  must be an even order FIR filter'])
		break
	end
	
	k = length(hLP);
	hBS = zeros(1,2*k);
	for m = 1:k-1
		hBS((m-1)*2+1) = hLP(m);
	end
